<?php

namespace Widget\ProductBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Model\ProductStyleMix;

/**
 * @DI\Service()
 */
class GetProductListener
{
    /**
     * @DI\Observe("event.product.add", priority=-20)
     */
    public function onGetProductInfo(ProductAddEvent $event)
    {
        $product = ProductQuery::create()
            ->filterById($event->getId())
            ->filterByStatusShelf(true)
            ->findOne($event->getConnection());
        if(!$product){
            $event->stopPropagation();
            return;
        }
        if ($product->getStyleStatus($event->getConnection())){
            return;
        }
        $event->setProductName($product->getName())
            ->setProductPrice($product->getPrice());
    }
}