<?php
namespace Widget\ProductBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\ProductBundle\Model\ProductQuery;

class ProductModelJoinStockEvent extends Event
{
    const EVENT_NAME = 'event.product.join.stock';
    protected $query;

    public function __construct(ProductQuery $query)
    {
        $this->query = $query;
    }

    /**
     * @return ProductQuery
     */
    public function getQuery()
    {
        return $this->query;
    }
}