<?php
namespace Widget\ProductBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Backend\BaseBundle\Form\Type\RelationType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;

use Symfony\Component\HttpFoundation\Response;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\ProductBundle\Model\CategoryProduct;
use Widget\ProductBundle\Model\Product;
use Widget\ProductBundle\Model\ProductPeer;
use Widget\ProductBundle\Model\ProductQuery;

/**
 * @Route("/productcategory")
 * @Security("has_role_or_superadmin('ROLE_PRODUCT_CATEGORY')")
 */
class ProductCategoryController extends BaseBackendAPIController
{

    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            new APIFormTypeItem('product_id'),
            new APIFormTypeItem('category_id'),
        );
    }

    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_CATEGORY_WRITE')")
     */
    public function createAction(Request $request)
    {
        return $this->doProcessForm(new CategoryProduct(), $request->getContent());
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_WRITE')")
     */
    public function updateAction(Request $request, CategoryProduct $categoryProduct)
    {
        return $this->doProcessForm($categoryProduct, $request->getContent());
    }

    /**
     * 刪除
     * @Route("/{id}")
     * @Method({"DELETE"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_CATEGORY_WRITE')")
     */
    public function deleteAction(CategoryProduct $categoryProduct)
    {
        $this->deleteObject($categoryProduct);
        return $this->createJsonResponse();
    }

    /**
     * 查詢產品分類API
     * @Route("s/all")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_READ')")
     */
    public function listAction(Request $request)
    {
        /** @var CategoryQuery $categoryQuery */
        $categoryQuery = CategoryQuery::create()
            ->filterByStatus(true)
            ->filterByTreeLevel(0, \Criteria::GREATER_EQUAL)
            ->useCategoryThreadQuery()
            ->filterByThread('product')
            ->endUse()
            ->find()
        ;

        if(!$categoryQuery){
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }

        return $this->createJsonSerializeResponse($categoryQuery, array('list'));
    }
}