<?php
namespace Widget\ProductBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Validator\Constraints as Assert;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\ProductBundle\Model\ProductQuery;

/**
 * @Route("/productcategory")
 */
class ProductCategoryController extends BaseController
{
    /**
     * 取得productcategory的API
     * @Route("/{id}", defaults={"id": 0})
     * @Method({"GET"})
     *
     */
    public function getProductCategoryAction($id)
    {

        /** @var CategoryQuery $categoryQuery */
        $categoryQuery = CategoryQuery::create()
            ->filterByStatus(true)
            ->useCategoryThreadQuery()
                ->filterByThread('product')
            ->endUse()
            ;
        if($id){
            $categoryQuery->filterById($id);
        }
        else{
            $categoryQuery->filterByTreeLevel(0);
        }
        $category = $categoryQuery->findOne();

        if(!$category){
            throw $this->createNotFoundException();
        }

        $children = $category->getChildren(CategoryQuery::create()->filterByStatus(true));
        return $this->createJsonSerializeResponse($children, array('list'));
    }

    /**
     * 取得ancestors的API
     * @Route("/{id}/ancestors")
     * @Method({"GET"})
     */
    public function getProductCategoryAncestorsAction($id)
    {

        /** @var CategoryQuery $categoryQuery */
        $categoryQuery = CategoryQuery::create()
            ->filterByStatus(true)
            ->useCategoryThreadQuery()
                ->filterByThread('product')
            ->endUse()
        ;
        if($id){
            $categoryQuery->filterById($id);
        }
        else{
            $categoryQuery->filterByTreeLevel(0);
        }
        $category = $categoryQuery->findOne();

        if(!$category){
            throw $this->createNotFoundException();
        }

        $ancestors = CategoryQuery::create()
            ->filterByStatus(true)
            ->inTree($category->getScopeValue())
            ->filterByTreeLeft($category->getLeftValue(), \Criteria::LESS_EQUAL)
            ->filterByTreeRight($category->getRightValue(), \Criteria::GREATER_EQUAL)
            ->orderByBranch()
            ->find();

        return $this->createJsonSerializeResponse($ancestors, array('list'));
    }

    /**
     * 取得product的API
     * @Route("/{id}/products")
     * @Method({"GET"})
     */
    public function getProductAction(Category $category, Request $request)
    {
        if( !$category->getStatus()
            || $category->getCategoryThread()->getThread() != 'product'){
            throw $this->createNotFoundException();
        }

        $parameters = $request->query->all();
        $page = $request->query->getInt('page', 1);
        $rowPerPage = $request->query->getInt('rowsperpage', 10);
        $sort = $request->query->get('sort');
        $orderby = $request->query->get('orderby');

        try {
            $query = ProductQuery::create();

            if ($sort !== null && $orderby !== null) {
                $query->orderBy($sort, $orderby);
            }

            $pager = $query
                ->distinct()
                ->filterByStatusShelf(true)
                ->useCategoryProductQuery()
                    ->useCategoryQuery()
                        ->filterByTreeLeft($category->getTreeLeft(), \Criteria::GREATER_EQUAL)
                        ->filterByTreeRight($category->getTreeRight(), \Criteria::LESS_EQUAL)
                    ->endUse()
                ->endUse();
            return $this->createJsonSerializeResponse(array(
                'category' => $category,
                'products' => $pager->paginate($page, $rowPerPage),
            ), array('list'));
        }
        catch (\PropelException $e){
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }
    }

}
