<?php

namespace Widget\ProductStyleBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\ProductStyleBundle\EventListener\GetProductStyleListener;
use Widget\ProductStyleBundle\Model\ProductStyleMixQuery;

class GetProductStyleListenerTest extends BaseWebTestCase
{
    public function test_onGetProductInfo()
    {
        // arrange
        $productStyleMix = ProductStyleMixQuery::create()->findOne();
        $productStyleMixId = $productStyleMix->getId();
        $product = $productStyleMix->getProduct();
        $productStyleName = "{$product->getName()} [{$productStyleMix->getName()}]";
        $count = 1;
        $event = new ProductAddEvent($productStyleMixId, $count);

        // act
        $getProductStyleListener = new GetProductStyleListener();
        $getProductStyleListener->onGetProductInfo($event);

        // assert
        $this->assertEquals($product->getPrice(), $event->getProductPrice());
        $this->assertEquals($productStyleName, $event->getProductName());
    }
}