<?php

namespace Widget\ProductStyleBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ProductStyleBundle\Model\ProductStyleTemplateQuery;

class ProductStyleTemplateController  extends BackendWebTestCase
{
    public function test_createAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        // fixtures 中 有寫入屬性規格的資料
        $params = array(
            'template_name' => '測試',
            'config' => array(
                'attrs' => array('紅色', '綠色')
            )
        );
        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_productstyle_backendapi_productstyletemplate_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['template_name'], $responseArray['template_name']);
        $this->assertEquals($params['config'], $responseArray['config']);

        ProductStyleTemplateQuery::create()->findPk($responseArray['id'])->delete();
    }

    public function test_searchAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'page' => 1,
            'sort' => array(
                'id' => 'asc'
            ),
            'search' => array(
                'template_name' => '%顏色%',
            ),
        );
        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_productstyle_backendapi_productstyletemplate_search', $params),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('id', $responseArray['data'][0]);
        $this->assertArrayHasKey('created_at', $responseArray['data'][0]);
        $this->assertArrayHasKey('updated_at', $responseArray['data'][0]);
    }

    public function test_readAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $productStyleTemplate = ProductStyleTemplateQuery::create()->findOne();
        $params = array(
            'id' => $productStyleTemplate->getId()
        );
        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_productstyle_backendapi_productstyletemplate_read', $params),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($productStyleTemplate->getId(), $responseArray['id']);
        $this->assertEquals($productStyleTemplate->getConfig(), $responseArray['config']);
        $this->assertEquals($productStyleTemplate->getTemplateName(), $responseArray['template_name']);
        $this->assertEquals($productStyleTemplate->getCreatedAt("Y-m-d\\TH:i:sP"), $responseArray['created_at']);
        $this->assertEquals($productStyleTemplate->getUpdatedAt("Y-m-d\\TH:i:sP"), $responseArray['updated_at']);
    }

    public function test_updateAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $productStyleTemplate = ProductStyleTemplateQuery::create()->findOne();
        $productStyleTemplateBack = $productStyleTemplate->toArray();
        $params = array(
            'template_name' => '公道預設組合'
        );
        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_productstyle_backendapi_productstyletemplate_update', array('id' => $productStyleTemplate->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['template_name'],$responseArray['template_name']);

        $productStyleTemplate->reload();
        $productStyleTemplate->fromArray($productStyleTemplateBack);
        $productStyleTemplate->save();
    }

    public function test_deleteAction()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $productStyleTemplate = ProductStyleTemplateQuery::create()->findOne();
        // act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_productstyle_backendapi_productstyletemplate_delete', array('id' => $productStyleTemplate->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $productStyleTemplateQuery = ProductStyleTemplateQuery::create()->findPk($productStyleTemplate->getId());
        $this->assertTrue($response->isOk());
        $this->assertNull($productStyleTemplateQuery);

        $con->rollBack();
    }

    public function test_listAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_productstyle_backendapi_productstyletemplate_list'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        // 只有2筆 fixtures 的資料
        $this->assertCount(2, $responseArray);
        $this->assertArrayHasKey('id', $responseArray[0]);
        $this->assertArrayHasKey('template_name', $responseArray[0]);
        $this->assertArrayHasKey('created_at', $responseArray[0]);
        $this->assertArrayHasKey('updated_at', $responseArray[0]);
    }
}