<?php

namespace Widget\ProductStyleBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Event\ProductStyleStockCreateEvent;
use Widget\ProductStyleBundle\Model\ProductStyleMixQuery;
use Widget\ProductStyleBundle\Model\ProductStyleTemplateQuery;

class ProductStyleControllerTest extends BackendWebTestCase
{
    public function test_queryAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        // fixtures 中 有寫入屬性規格的資料
        $params = array(
            'template_ids' => array(
                1,2
            )
        );
        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_productstyle_backendapi_productstyle_query'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertCount(6, $responseArray);
    }
    
    public function test_createAction()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $hasTrigger = false;
        
        $params = array(
            'template_ids' => array(1,2),
            'product_id' => ProductQuery::create()->orderById(\Criteria::DESC)->findOne()->getId(),
            'default_style' => false,
        );
        $eventDispatcher = $this->client->getContainer()->get('event_dispatcher');
        $eventDispatcher->addListener(ProductStyleStockCreateEvent::EVENT_NAME, function(ProductStyleStockCreateEvent $event) use(&$hasTrigger){
            $hasTrigger = true;
            $event->stopPropagation();
        }, 99999);
        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_productstyle_backendapi_productstyle_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );

        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);
        // assert

        $this->assertTrue($response->isOk());
        $this->assertTrue($hasTrigger);
        // 預計會寫入2種屬性Log
        $this->assertCount(2, $responseArray['styles']);

        $con->rollBack();
    }

    public function test_createAction_default_style()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $hasTrigger = false;

        $params = array(
            'template_ids' => array(1,2),
            'product_id' => ProductQuery::create()->orderById(\Criteria::DESC)->findOne()->getId(),
            'default_style' => true,
        );
        $eventDispatcher = $this->client->getContainer()->get('event_dispatcher');
        $eventDispatcher->addListener(ProductStyleStockCreateEvent::EVENT_NAME, function(ProductStyleStockCreateEvent $event) use(&$hasTrigger){
            $hasTrigger = true;
            $event->stopPropagation();
        }, 99999);
        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_productstyle_backendapi_productstyle_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );

        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertTrue($hasTrigger);
        
        // 預計會寫入0種屬性Log
        $this->assertCount(0, $responseArray['styles']);

        $con->rollBack();
    }

    /**
     * @group debug
     */
    public function test_deleteAction()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();
        
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        // fixtures 中 有寫入屬性規格的資料
        $id = ProductQuery::create()->filterByCode('golfy')->findOne()->getId();
        $this->createProductStyle($id);

        // act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_productstyle_backendapi_productstyle_delete', array('id' => $id)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $product = ProductQuery::create()->findPk($id);
        $this->assertTrue($response->isOk());
        $this->assertEquals(0, $product->getProductStyleTemplateLogs()->count());
        $this->assertEquals(0, $product->getProductToStyleConfigs()->count());
        
        $con->rollBack();

    }

    protected function createProductStyle($productId)
    {
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'template_ids' => array(1,2),
            'product_id' => $productId,
            'default_style' => false,
        );
        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_productstyle_backendapi_productstyle_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
    }
}