<?php

namespace Widget\ProductStyleBundle\Tests\Command;


use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\ProductBundle\Model\Product;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Command\MigrateToProductStyleCommand;
use Widget\ProductStyleBundle\Model\ProductStyle;
use Widget\ProductStyleBundle\Model\ProductStyleLabel;
use Widget\ProductStyleBundle\Model\ProductStyleLabelQuery;
use Widget\ProductStyleBundle\Model\ProductStyleMixQuery;
use Widget\ProductStyleBundle\Model\ProductStyleQuery;

class MigrateToProductStyleCommandTest extends BaseWebTestCase
{
    


    public function test_createDefaultStyleMix()
    {
        // arrange
        $migrateToProductStyleCommand = $this->getMockBuilder(MigrateToProductStyleCommand::class)
            ->disableOriginalConstructor()
            ->getMock();

        $product = ProductQuery::create()->orderById(\Criteria::DESC)->findOne();

        // act
        /** @var ProductStyle $defaultStyle */
        $defaultStyleMix = $this->callObjectMethod($migrateToProductStyleCommand, 'createDefaultStyleMix', $product->getId(), $product->getId());
        $productStyleMixQuery = ProductStyleMixQuery::create()->findPk($defaultStyleMix->getId());

        // assert
        $this->assertEquals($productStyleMixQuery->getId(), $productStyleMixQuery->getId());
        $this->assertEquals($productStyleMixQuery->getName(), $productStyleMixQuery->getName());

        $defaultStyleMix->delete();
    }
}