<?php

namespace Widget\ProductStyleBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\ProductStyleBundle\Model\ProductStyleMixQuery;

/**
 * @DI\Service()
 */
class GetProductStyleListener
{
    /**
     * @DI\Observe("event.product.add", priority=-10)
     */
    public function onGetProductInfo(ProductAddEvent $event)
    {
        $productStyleMix = ProductStyleMixQuery::create()->findPk($event->getId(), $event->getConnection());
        if ($productStyleMix == null) {
            return;
        }

        $product = $productStyleMix->getProduct($event->getConnection());
        if (!$product->getStatusShelf()) {
            $event->stopPropagation();
            return;
        }
        if ($productStyleMix->getName() == ""){
            $event->setProductName("{$product->getName()}")
                ->setProductPrice($product->getPrice());
        }
        else {
            $event->setProductName("{$product->getName()} [{$productStyleMix->getName()}]")
                ->setProductPrice($product->getPrice());
        }

    }
}