<?php

namespace Widget\ProductStyleBundle\Event;


use Symfony\Component\EventDispatcher\Event;

class ProductStyleStockMigrateEvent extends Event
{
    const EVENT_NAME = 'event.product.style.stock.migrate';
    
    protected $productIds = array();
    
    protected $productStyleMixIds = array();

    /**
     * @return array
     */
    public function getProductIds()
    {
        return $this->productIds;
    }

    /**
     * @param integer $productIds
     */
    public function addProductIds($productIds)
    {
        $this->productIds[] = $productIds;
    }

    /**
     * @return array
     */
    public function getProductStyleMixIds()
    {
        return $this->productStyleMixIds;
    }

    /**
     * @param integer $productStyleMixIds
     */
    public function addProductStyleMixIds($productStyleMixIds)
    {
        $this->productStyleMixIds[] = $productStyleMixIds;
    }
}