<?php

namespace Widget\ProductStyleBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class ProductStyleStockCreateEvent extends Event
{
    const EVENT_NAME = 'event.product.style.create.stock';

    protected $productId;

    protected $productMixArray = array();

    public function __construct($productId,$mix)
    {
        $this->productId = $productId;
        $this->productMixArray = $mix;
    }

    /**
     * @return array
     */
    public function getProductMixArray()
    {
        return $this->productMixArray;
    }

    /**
     * @return mixed
     */
    public function getProductId()
    {
        return $this->productId;
    }

}