<?php

namespace Widget\ProductStyleBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Backend\BaseBundle\Form\Type\BaseFormType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Validator\Constraints\NotBlank;
use Widget\ProductStyleBundle\Model\ProductStyleTemplate;
use Widget\ProductStyleBundle\Model\ProductStyleTemplatePeer;
use Widget\ProductStyleBundle\Model\ProductStyleTemplateQuery;

/**
 * @Route("/producttemple")
 * @Security("has_role_or_superadmin('ROLE_PRODUCT')")
 */
class ProductStyleTemplateController extends BaseBackendAPIController
{
    public function getFormConfig()
    {
        return array(
            (new APIFormTypeItem('template_name'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.product_style.template_name.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('config'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.product_style.attr.missing_field',
                    )),
                )                
            )),
        );
    }

    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_WRITE')")
     */
    public function createAction(Request $request)
    {
        return $this->doProcessForm(new ProductStyleTemplate(), $request->getContent());
    }

    /**
     * 搜尋
     * @Route("s")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_READ')")
     */
    public function searchAction(Request $request)
    {
        return $this->doSearch($request->query->all(), ProductStyleTemplateQuery::create()->distinct(), ProductStyleTemplatePeer::class);
    }

    /**
     * 讀取
     * @Route("/{id}")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_READ')")
     */
    public function readAction(ProductStyleTemplate $productStyleTemplate)
    {
        return $this->createJsonSerializeResponse($productStyleTemplate, array('detail'));
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_WRITE')")
     */
    public function updateAction(Request $request, ProductStyleTemplate $productStyleTemplate)
    {
        return $this->doProcessForm($productStyleTemplate, $request->getContent());
    }

    /**
     * 刪除
     * @Route("/{id}")
     * @Method({"DELETE"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_WRITE')")
     */
    public function deleteAction(ProductStyleTemplate $productStyleTemplate)
    {
        $this->deleteObject($productStyleTemplate);
        return $this->createJsonResponse();
    }

    /**
     * 讀取
     * @Route("s/all")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_WRITE')")
     */
    public function listAction(Request $request)
    {
        $productStyleTemplates = ProductStyleTemplateQuery::create()->find();
        if (!$productStyleTemplates){
            return new Response('', Response::HTTP_BAD_REQUEST);
        }
        return $this->createJsonSerializeResponse($productStyleTemplates, array('detail'));
    }

    /**
     * 批次管理
     * @Route("s")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_WRITE')")
     */
    public function batchAction(Request $request)
    {
        return parent::batchAction($request);
    }

    /**
     * 批次切換狀態處理
     * @param $ids
     * @param $con
     * @param $column
     */
    protected function batchSwitch($ids, $column, \PropelPDO $con)
    {
        $members = ProductStyleTemplateQuery::create()->findPks($ids, $con);
        foreach ($members as $member) {
            $value = $member->getByName($column, \BasePeer::TYPE_FIELDNAME);
            $member->setByName($column, !$value, \BasePeer::TYPE_FIELDNAME);
            $member->save($con);
        }
    }

    /**
     * 批次設定值
     * @param $ids
     * @param $column
     * @param $value
     * @param \PropelPDO $con
     * @return \Symfony\Component\HttpFoundation\JsonResponse|void
     */
    protected function batchValue($ids, $column, $value, \PropelPDO $con)
    {
        $members = ProductStyleTemplateQuery::create()->findPks($ids, $con);
        foreach ($members as $member) {
            $member->setByName($column, $value, \BasePeer::TYPE_FIELDNAME);
            $member->save($con);
        }
    }

    /**
     * 批次切換狀態處理
     * @param $ids
     * @param $con
     * @param $column
     */
    protected function batchDelete($ids, \PropelPDO $con)
    {
        ProductStyleTemplateQuery::create()->findPks($ids, $con)->delete($con);
    }
}