<?php

namespace Widget\ProductStyleBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Widget\ProductBundle\Model\Product;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Event\ProductStyleStockMigrateEvent;
use Widget\ProductStyleBundle\Model\ProductStyle;
use Widget\ProductStyleBundle\Model\ProductStyleLabel;
use Widget\ProductStyleBundle\Model\ProductStyleMix;

class MigrateToProductStyleCommand extends ContainerAwareCommand
{
    /**
     * @see Command
     */
    protected function configure()
    {
        $this
            ->setName('dgfactor:productstyle:migrate')
            ->setDescription('將產品改為擁有屬性/規格的schema')
            ->addOption('force', null, InputOption::VALUE_NONE, '請加入這個參數，確認執行')
            ->setHelp(<<<EOT
<info>dgfactor:productstyle:migrate</info> 將產品/庫存搬到擁有屬性/規格的table.
EOT
            );
    }

    /**
     * @see Command
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {

        if(!$input->getOption('force')){
            $output->writeln("<error>請加上 --force 確認執行</error>");
            return;
        }
        $products = ProductQuery::create()->orderById(\Criteria::ASC)->find();
        $event = new ProductStyleStockMigrateEvent();
        $con = \Propel::getConnection();
        $con->beginTransaction();
        try {
            /** @var Product $product */
            foreach ($products as $product){
                if ($product->getProductStyleMixes()->count() >= 1){
                    continue;
                }
                $productId = $product->getId();
                $productStyleMix = $this->createDefaultStyleMix($productId, $productId);

                $event->addProductIds($productId);
                $event->addProductStyleMixIds($productStyleMix->getId());
            }

            /** @var EventDispatcher $eventDispatcher */
            $eventDispatcher = $this->getContainer()->get('event_dispatcher');
            $eventDispatcher->dispatch(ProductStyleStockMigrateEvent::EVENT_NAME, $event);
        }
        catch (\Exception $e){
            $con->rollBack();
            $output->writeln($e->getMessage());
            return;
        }
        $con->commit();

        $output->writeln('搬移完成');

    }

    /**
     * 建立預設組合
     */
    protected function createDefaultStyleMix($productId, $productStyleId)
    {
        $productStyleMix = new ProductStyleMix();
        $productStyleMix->setId($productStyleId);
        $productStyleMix->setProductId($productId);
        $productStyleMix->setName('');
        $productStyleMix->save();
        return $productStyleMix;
    }

}