<?php
namespace Widget\PhotoBundle\Twig\Extension;

use Backend\BaseBundle\Event\TwigRenderEvent;
use JMS\DiExtraBundle\Annotation\Observe;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\PhotoBundle\Image\PhotoList;
use Widget\PhotoBundle\Image\Resolver;
use Widget\PhotoBundle\Model\Photo;

/**
 * @Service
 * @Tag("twig.extension", attributes = {"public": false})
 */
class PhotoResolverTwigExtension extends \Twig_Extension
{

    /** @var  Resolver */
    protected $resolver;

    /**
     * @InjectParams({
     *    "resolver" = @Inject("widget_photo.image.resolver"),
     * })
     */
    public function injectService(Resolver $resolver)
    {
        $this->resolver = $resolver;
    }

    public function getFunctions()
    {
        return array(
            new \Twig_SimpleFunction('resolve', array($this, 'resolvePhotoWebPath')),
            new \Twig_SimpleFunction('isPhoto', array($this, 'isPhoto')),
        );
    }

    public function isPhoto($value)
    {
        return $value instanceof Photo;
    }

    public function resolvePhotoWebPath($photo, $suffix, $ext = null)
    {
        if($photo == null){
            return '';
        }

        if($photo instanceof Photo){
            return $this->resolver->resolveWebPath($photo, $suffix);
        }

        return $this->resolver->resolveWebPathFromUid($photo, $suffix, $ext);
    }

    /**
     * @Observe(TwigRenderEvent::EVENT_TWIG_RENDER_EVENT)
     */
    public function PhotoListObjectRender(TwigRenderEvent $event)
    {
        $value = $event->getValue();
        if(!($value instanceof PhotoList)){
            return;
        }

        $event->stopPropagation();

        if(!($photo = $value->getMasterPhoto())){
            $event->setRendered(array(
                'type' => 'text',
                'value' => '',
            ));
            return;
        }

        $event->setRendered(array(
            'type' => 'image',
            'value' => $this->resolvePhotoWebPath($photo, 'tiny')
        ));
    }

    /**
     * @Observe(TwigRenderEvent::EVENT_TWIG_RENDER_EVENT)
     */
    public function PhotoObjectRender(TwigRenderEvent $event)
    {
        $value = $event->getValue();
        if(!($value instanceof Photo)){
            return;
        }

        $event->stopPropagation();

        $event->setRendered(array(
            'type' => 'image',
            'value' => $this->resolvePhotoWebPath($value, 'tiny')
        ));
    }

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return "WidgetPhotoResolver";
    }
}