<?php
namespace Widget\PhotoBundle\Image;


use Widget\PhotoBundle\File\PhotoUploadFile;
use Widget\PhotoBundle\Model\Photo;
use Widget\PhotoBundle\Model\PhotoConfig;

class PhotoList extends \ArrayIterator
{
    protected $modified = false;
    protected $masterIndex = 0;

    private $photoConfig = null;

    public function __construct(array $array, $flags = 0)
    {
        parent::__construct(array_values($array), $flags);
        $this->modified = true;
    }

    public function setPhotoConfig(PhotoConfig $photoConfig)
    {
        $this->photoConfig = $photoConfig;
    }

    public function offsetSet($index, $newval)
    {
        if(!($newval instanceof PhotoUploadFile || $newval instanceof Photo)){
            return;
        }
        parent::offsetSet($index, $newval); // TODO: Change the autogenerated stub
        $this->modified = true;
    }

    public function offsetUnset($index)
    {
        if(!parent::offsetExists($index)){
            return;
        }
        parent::offsetUnset($index); // TODO: Change the autogenerated stub
        $this->modified = true;
    }

    public function append($value)
    {
        if(!($value instanceof PhotoUploadFile || $value instanceof Photo)){
            return;
        }
        parent::append($value); // TODO: Change the autogenerated stub
        $this->modified = true;
    }

    public function isModified()
    {
        return $this->modified;
    }

    public function save($siteId, \PropelPDO $con = null)
    {
        if(!$this->isModified()){
            return;
        }
        foreach ($this as $index => $item){
            if($item instanceof PhotoUploadFile){
                if($this->photoConfig) {
                    $item->setPhotoConfig($this->photoConfig);
                }
                $photo = $item->makePhoto();
                $photo->setSiteId($siteId);
                $photo->save($con);
                $this[$index] = $photo;
            }
        }
        $this->modified = false;
    }

    public function setMasterPhotoIndex($index)
    {
        $this->masterIndex = $index;
    }

    public function setMasterPhoto()
    {
        
    }

    public function getMasterPhoto()
    {
        return isset($this[$this->masterIndex])?$this[$this->masterIndex]:null;
    }
}