<?php
namespace Widget\PhotoBundle\Image;

use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Widget\PhotoBundle\Model\PhotoConfig;
use Widget\PhotoBundle\Model\PhotoConfigQuery;

/**
 * @DI\Service("widget.photo_bundle.config_finder")
 */
class PhotoConfigFinder
{
    protected $defaultPhotoConfig;

    /**
     * @InjectParams({
     *     "config" = @Inject("%widget_photo.default_config%"),
     * })
     */
    public function injectDefaultPhotoConfig($config)
    {
        $this->defaultPhotoConfig = $config;
    }

    public function findConfig($siteId, $name, $autoCreateDefault = true)
    {
        $config = PhotoConfigQuery::create()
            ->filterBySiteId($siteId)
            ->filterByName($name)
            ->findOne();
        if($config){
            return $config;
        }
        if($autoCreateDefault) {
            return $this->findDefaultConfig($siteId);
        }
        return null;
    }

    protected function findDefaultConfig($siteId)
    {
        if($defaultConfig = $this->findConfig($siteId, 'default', false)){
            return $defaultConfig;
        }

        return $this->createDefaultConfig($siteId);
    }

    protected function createDefaultConfig($siteId)
    {
        $config = new PhotoConfig();
        $config->setSiteId($siteId);
        $config->setConfig($this->defaultPhotoConfig);
        $config->setName('default');
        $config->setBrief('default');
        $config->save();
        return $config;
    }
}