window.readImageFile = ($widget) ->
  file = $widget.find('input[type=file]')[0].files[0]
  $image = $widget.find('*[data-photo-upload-image]')
  $preview = $widget.find('*[data-photo-upload-preview]')
  return if !window.FileReader
  return if !file || !/^image\/\w+$/.test(file.type)
  $image.removeClass('hide').show()
  reader = new FileReader()
  reader.onload = () ->
    if $image.attr('data-photo-upload-image') != 'crop'
      $image.attr('src', reader.result)
      return
    $image.cropper
      preview: $preview
      crop:    (e) ->
        data = $image.cropper('getData')
        $widget.find('*[data-photo-upload-crop=x]').val data.x
        $widget.find('*[data-photo-upload-crop=y]').val data.y
        $widget.find('*[data-photo-upload-crop=w]').val data.width
        $widget.find('*[data-photo-upload-crop=h]').val data.height
        return
    $image.cropper("replace", reader.result)
    return
  reader.readAsDataURL file
  return

$ () ->
  $('*[data-photo-upload-widget] input[type=file]').addClass 'hide'
  $('body').on 'change', '[data-photo-upload-master-field]', (e) ->
    id = $(@).attr 'data-photo-upload-master-field'
    $("##{id}").val $(@).val()
  $('body').on 'change', '[data-photo-upload-widget] input[type=file]', (e) ->
    $widget = $(@).parents('*[data-photo-upload-widget]')
    readImageFile $widget
    return
  return