<?php
namespace Widget\PhotoBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints;
use Backend\BaseBundle\Model;
use Backend\BaseBundle\Event\RoleTypeEvent;
use Widget\PhotoBundle\Model as PhotoModel;

/**
 *
 * @Route("/photo")
 */
class MainController extends BaseController
{
    /**
     * @Route("/")
     * @Method({"GET"})
     */
    public function getPhotos(Model\Site $site, Request $request)
    {
        $suffix = $request->get('suffix', 'small');
        $photoArray = array();
        $helper = $this->get('templating.helper.assets');
        $resolver = $this->get('widget_photo.image.resolver');

        $photos = PhotoModel\PhotoQuery::create()
            ->filterBySiteId($site->getId())
            ->find();

        foreach ($photos as $photo) {
            /** @var PhotoModel\Photo $photo*/
            $photoArray[] = array(
                'uid' => $photo->getUid(),
                'path' => $helper->getUrl($resolver->resolveWebPath($photo, $suffix)),
                'info' => $photo->getInfo(),
            );
        }

        return $this->createJsonResponse($photoArray);
    }
}