<?php

namespace Widget\Payment\ZeroFreeBundle\Tests\Controller;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Payment\ZeroFreeBundle\Processer\ZeroFreeProcesser;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

class ZeroFreeProcesserTest extends BaseWebTestCase
{
    public function test_getProcesser_invalid_paymentType()
    {
        //arrange
        $paymentType = 'bad_payment_type';
        $event = new GetProcesserEvent($paymentType);
        $processer = new ZeroFreeProcesser();

        //act
        $processer->getProcesser($event);

        //assert
        $this->assertFalse($event->isPropagationStopped());
        $this->assertNull($event->getProcesser());
    }

    public function test_getProcesser_valid_paymentType()
    {
        //arrange
        $paymentType = 'ZeroFree';
        $event = new GetProcesserEvent($paymentType);
        $processer = new ZeroFreeProcesser();

        //act
        $processer->getProcesser($event);

        //assert
        $this->assertTrue($event->isPropagationStopped());
        $this->assertTrue($processer === $event->getProcesser());
    }

    public function test_onProcess_bad_paymentType()
    {
        //arrange
        $paymentType = 'badPaymentType';
        $ordernumber = 'P12345';
        $amount = 1000;
        $paymentExtraInfo = array();
        $event = new ProcessPaymentEvent($paymentType, $ordernumber, $amount, $paymentExtraInfo);
        $processer = new ZeroFreeProcesser();

        //act
        $processer->onProcess($event);

        //assert
        $this->assertFalse($event->isPropagationStopped());
    }

    public function test_onProcess()
    {
        //arrange
        $paymentType = 'ZeroFree';
        $ordernumber = 'P0003';
        $amount = 0;
        $paymentNumber = '123456789';
        $returnUrl = 'http://example.com/test_return_url';
        $paymentExtraInfo = array();
        $config = array();
        $event = new ProcessPaymentEvent($paymentType, $ordernumber, $amount, $paymentExtraInfo);

        $processer = $this->getMockBuilder(ZeroFreeProcesser::class)
            ->setMethods(array(
                'findPayment',
                'emitReceiveOrder',
                'emitReturnUrl',
            ))
            ->getMock();
        $this->setObjectAttribute($processer, 'config', array());

        $processer
            ->expects($this->once())
            ->method('findPayment')
            ->willReturnCallback(function($ordernumberForTest, $autoCreate) use($ordernumber){
                $this->assertEquals($ordernumber, $ordernumberForTest);
                $this->assertTrue($autoCreate);
            });
        $processer
            ->expects($this->once())
            ->method('emitReceiveOrder')
            ->willReturnCallback(function(ReceiveOrderEvent $event) use($ordernumber, $amount, $paymentExtraInfo){
                $this->assertEquals($paymentExtraInfo, $event->getOriginInfo());
                $this->assertTrue($event->getStatus());
                $this->assertEquals($ordernumber, $event->getOrdernumber());
                $this->assertEquals($amount, $event->getAmount());
            });
        $processer
            ->expects($this->once())
            ->method('emitReturnUrl')
            ->willReturnCallback(function(ReturnUrlEvent $event) use($returnUrl){
                $event->setUrl($returnUrl);
            });

        //act
        $processer->onProcess($event);
        $response = $event->getProcesserResult()->makeResponse();

        //assert
        $this->assertTrue($event->isPropagationStopped());
        $this->assertTrue($response->isRedirect($returnUrl));
    }
}