<?php

namespace Widget\Payment\ZeroFreeBundle\Processer;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\PaymentBundle\Model\Payment;
use Widget\PaymentBundle\Processer\ProcesserBase;

/**
 * @DI\Service("widget_payment.processer.zero_free")
 */
class ZeroFreeProcesser extends ProcesserBase
{
    const PROCESSER_NAME = 'ZeroFree';

    /**
     * @DI\InjectParams({
     *    "config" = @DI\Inject("widget_payment.config"),
     * })
     */
    public function injectConfig($config)
    {
        $this->config = array();
    }

    /**
     * @DI\Observe(GetProcesserEvent::EVENT_NAME)
     */
    public function getProcesser(GetProcesserEvent $event)
    {
        if($event->getPaymentType() != self::PROCESSER_NAME){
            return;
        }
        $event->stopPropagation();
        $event->setProcesser($this);
    }

    /**
     * 回到結帳完成頁
     * @DI\Observe(ProcessPaymentEvent::EVENT_NAME)
     */
    public function onProcess(ProcessPaymentEvent $event)
    {
        if($event->getPaymentType() != self::PROCESSER_NAME){
            return;
        }
        $event->stopPropagation();

        $this->findPayment($event->getOrdernumber(), true);

        $receiveOrderEvent = new ReceiveOrderEvent($event->getOrdernumber(), $event->getAmount(), true, $event->getPaymentType(), array());
        $this->emitReceiveOrder($receiveOrderEvent);

        $returnUrlEvent = new ReturnUrlEvent($event->getOrdernumber());
        $this->emitReturnUrl($returnUrlEvent);
        $event->getProcesserResult()->setForwardRedirect($returnUrlEvent->getUrl());
    }

    /**
     * 建立付款資料
     * @param $ordernumber
     * @return mixed|\Widget\PaymentBundle\Model\Payment|\Widget\PaymentBundle\Model\Payment[]
     */
    protected function findPayment($ordernumber, $autoCreate = false)
    {
        /** @var Order $order */
        $order = OrderQuery::create()->findPk($ordernumber);

        if(!$order){
            return null;
        }

        if(!$order->getPayment() && $autoCreate){
            $payment = new Payment();
            $payment->setOrder($order);
        }
    }
}