<?php
namespace Widget\PaymentBundle\Tests\Processer;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\VerifyAmountEvent;
use Widget\PaymentBundle\Processer\ProcesserBase;
use Symfony\Component\EventDispatcher\EventDispatcher;

class ProcesserBaseTest extends BaseTestCase
{
    public function test_injectDispatcher()
    {
        //arrange
        $dispatcher = $this->getMockBuilder(EventDispatcher::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $processer = $this->getMockForAbstractClass(ProcesserBase::class);

        //act
        $processer->injectDispatcher($dispatcher);

        //assert
        $this->assertEquals($dispatcher, $this->getObjectAttribute($processer, 'dispatcher'));
    }

    public function test_emitVerifyOrder()
    {
        //arrange
        $config = array('a', 'b', 'c');
        $event = new VerifyAmountEvent('abcdefg', 1000);
        $dispatcher = $this->getMockBuilder(EventDispatcher::class)
            ->setMethods(array('dispatch'))
            ->disableOriginalConstructor()
            ->getMock();
        $dispatcher
            ->expects($this->once())
            ->method('dispatch')
            ->willReturnCallback(function($eventName, $eventForTest) use($event){
                $this->assertEquals(VerifyAmountEvent::EVENT_NAME, $eventName);
                $this->assertEquals($event, $eventForTest);
            });
        $processer = $this->getMockForAbstractClass(ProcesserBase::class, array(), '', false);
        $this->setObjectAttribute($processer, 'dispatcher', $dispatcher);

        //act
        $processer->emitVerifyOrder($event);
    }
}