<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/13
 * Time: 下午 5:02
 */

namespace Widget\PaymentBundle\Tests\EventListener;


use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\PaymentBundle\EventListener\PaymentRecoverListener;

class PaymentRecoverListenerTest extends BaseWebTestCase
{
    public function test_onReceivePaymentQueryFailEvent()
    {
        //arrange
        $query = $this->getMockBuilder(OrderQuery::class)
            ->disableOriginalConstructor()
            ->setMethods(array('usePaymentQuery', 'filterByPaymentExpiredAt', 'filterByPaymentPaid', 'endUse'))
            ->getMock();
        $query->expects($this->once())
            ->method('usePaymentQuery')
            ->willReturn($query);
        $query->expects($this->once())
            ->method('filterByPaymentExpiredAt')
            ->willReturn($query);
        $query->expects($this->once())
            ->method('filterByPaymentPaid')
            ->willReturn($query);
        $query->expects($this->once())
            ->method('endUse')
            ->willReturn($query);
        $event = new ReceiveOrderQueryStatusEvent($query);
        $listener = new PaymentRecoverListener();

        //act
        $listener->onReceivePaymentQueryFailEvent($event);
        //assert
    }
}