<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\VerifyAmountEvent;

class VerifyAmountEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $ordernumber = 'o123456';
        $amount = 100;

        //act
        $event = new VerifyAmountEvent($ordernumber, $amount);

        //assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($event, 'ordernumber'));
        $this->assertEquals($amount, $this->getObjectAttribute($event, 'amount'));
    }

    public function test_getOrdernumber()
    {
        //arrange
        $ordernumber = 'o12345';
        $event = $this->getMockBuilder(VerifyAmountEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'ordernumber', $ordernumber);

        //act
        $result = $event->getOrdernumber();

        //assert
        $this->assertEquals($ordernumber, $result);
    }

    public function test_getAmount()
    {
        //arrange
        $amount = 1234;
        $event = $this->getMockBuilder(VerifyAmountEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'amount', $amount);

        //act
        $result = $event->getAmount();

        //assert
        $this->assertEquals($amount, $result);
    }

    public function test_isValid()
    {
        //arrange
        $valid = true;
        $event = $this->getMockBuilder(VerifyAmountEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'valid', $valid);

        //act
        $result = $event->isValid();

        //assert
        $this->assertEquals($valid, $result);
    }

    public function test_setValid()
    {
        //arrange
        $valid = false;
        $event = $this->getMockBuilder(VerifyAmountEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        //act
        $result = $event->setValid($valid);

        //assert
        $this->assertEquals($valid, $this->getObjectAttribute($event, 'valid'));
    }

}