<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\UpdatePaymentTypeEvent;

class UpdatePaymentTypeEventTest extends BaseTestCase
{
    public function  test___construct_default_value()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";
        $amount = 100;
        $currency = 'TWD';
        $unit = 0;

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType, $amount);

        // assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($updatePayment,'ordernumber'));
        $this->assertEquals($paymentType, $this->getObjectAttribute($updatePayment,'paymentType'));
        $this->assertEquals($amount, $this->getObjectAttribute($updatePayment,'amount'));
        $this->assertEquals($currency, $this->getObjectAttribute($updatePayment, 'currency'));
        $this->assertEquals($unit, $this->getObjectAttribute($updatePayment, 'unit'));
    }

    public function  test___construct()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";
        $amount = 100;
        $currency = 'CYN';
        $unit = 2;

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType, $amount, $currency, $unit);

        // assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($updatePayment,'ordernumber'));
        $this->assertEquals($paymentType, $this->getObjectAttribute($updatePayment,'paymentType'));
        $this->assertEquals($amount, $this->getObjectAttribute($updatePayment,'amount'));
        $this->assertEquals($currency, $this->getObjectAttribute($updatePayment, 'currency'));
        $this->assertEquals($unit, $this->getObjectAttribute($updatePayment, 'unit'));
    }

    public function test_getOrdernumber()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";
        $amount = 100;

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType, $amount);

        // assert
        $this->assertEquals($ordernumber, $updatePayment->getOrdernumber());

    }

    public function test_getPaymentType()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";
        $amount = 100;

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType, $amount);

        // assert
        $this->assertEquals($paymentType, $updatePayment->getPaymentType());
    }
}