<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\ReturnUrlEvent;

class ReturnUrlEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $ordernumber = 'o123456';

        //act
        $event = new ReturnUrlEvent($ordernumber);

        //assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($event, 'ordernumber'));
    }

    public function test_getOrdernumber()
    {
        //arrange
        $ordernumber = 'o12345';
        $event = $this->getMockBuilder(ReturnUrlEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'ordernumber', $ordernumber);

        //act
        $result = $event->getOrdernumber();

        //assert
        $this->assertEquals($ordernumber, $result);
    }

    public function test_getUrl()
    {
        //arrange
        $url = 'http://localhost/';
        $event = $this->getMockBuilder(ReturnUrlEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'url', $url);

        //act
        $result = $event->getUrl();

        //assert
        $this->assertEquals($url, $result);
    }

    public function test_setUrl()
    {
        //arrange
        $url = 'http://localhost/';
        $event = $this->getMockBuilder(ReturnUrlEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        //act
        $result = $event->setUrl($url);

        //assert
        $this->assertEquals($url, $this->getObjectAttribute($event, 'url'));
    }

}