<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Processer;

class GetProcesserEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $paymentType = 'TestCredit';

        //act
        $event = new GetProcesserEvent($paymentType);

        //assert
        $this->assertEquals($paymentType, $this->getObjectAttribute($event, 'paymentType'));
    }

    public function test_getPaymentType()
    {
        //arrange
        $paymentType = 'TestCredit';
        $event = $this->getMockBuilder(GetProcesserEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'paymentType', $paymentType);

        //act
        $result = $event->getPaymentType();

        //assert
        $this->assertEquals($paymentType, $result);
    }

    public function test_setProcesser()
    {
        //arrange
        $processer = $this->getMockBuilder(Processer\ProcesserBase::class)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $event = $this->getMockBuilder(GetProcesserEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        //act
        $event->setProcesser($processer);

        //assert
        $this->assertEquals($processer, $this->getObjectAttribute($event, 'processer'));
    }

    public function test_getProcesser()
    {
        //arrange
        $processer = $this->getMockBuilder(Processer\ProcesserBase::class)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $event = $this->getMockBuilder(GetProcesserEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMockForAbstractClass();
        $this->setObjectAttribute($event, 'processer', $processer);

        //act
        $result = $event->getProcesser($processer);

        //assert
        $this->assertEquals($processer, $result);
    }

}