module.exports =
{
  "list": {
    "id": {
      "label": "index.order.id"
      "type": "id"
      "sort": true
      "search": true
      "defaultSorting": 'desc'
      searchConfig:
        key: "id"
        type: "text"
        like: true
    },
    "amount": {
      "label": "index.payment.amount"
      "type": "text"
      "sort": true
    },
    "payment_type": {
      "label": "index.order.payment_type"
      "type": "text"
      "sort": true
      "config": {
        label_prefix: "index_value.payment.payment_type"
      }
    },
    "payment_number": {
      "label": "index.order.payment_number"
      "type": "text"
      "sort": true
    },
    "payment_paid_at": {
      "label": "index.payment.payment_paid_at"
      "type": "datetime-local"
      "sort": true
    },
    "payment_expired_at": {
      "label": "index.order.payment_expired_at"
      "type": "datetime-local"
      "sort": true
    },
    "payment_status": {
      "label": "index.order.payment_status"
      "type": "text"
      "sort": true
      "config":{
        label_prefix: "index_value.payment.payment_status"
      }
    },
    "created_at": {
      "label": "index.order.created_at"
      "type": "datetime-local"
      "sort": true
    }
  },
  "extra": [],
  "action": [
    {
      "name": "view",
      "label": "action.view",
      "roles": ["ROLE_PAYMENT_READ", "ROLE_PAYMENT_WRITE"]
      "route": 'payment-view'
    },
  ]
}