<?php
namespace Widget\PaymentBundle\Processer;

use Backend\BaseBundle\Service\APIRequestTrait;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Widget\OrderBundle\Event\ReceiveCreateOrderEvent;
use Widget\PaymentBundle\Event\GetProcesserEvent;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;
use Widget\PaymentBundle\Event\ReceivePaymentnumberEvent;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\PaymentBundle\Event\VerifyAmountEvent;

abstract class ProcesserBase
{
    use APIRequestTrait;

    /**
     * @var EventDispatcherInterface
     */
    protected $dispatcher;
    protected $config;

    abstract public function getProcesser(GetProcesserEvent $event);
    abstract public function injectConfig($config);

    /**
     * @InjectParams()
     */
    public function injectDispatcher(EventDispatcherInterface $eventDispatcher)
    {
        $this->dispatcher = $eventDispatcher;
    }

    /**
     * 驗證付款金額
     */
    public function emitVerifyOrder(VerifyAmountEvent $event)
    {
        $this->dispatcher->dispatch(VerifyAmountEvent::EVENT_NAME, $event);
    }

    /**
     * 收到錢了
     */
    public function emitReceiveOrder(ReceiveOrderEvent $event)
    {
        $this->dispatcher->dispatch(ReceiveOrderEvent::EVENT_NAME, $event);
    }

    public function emitReturnUrl(ReturnUrlEvent $event)
    {
        $this->dispatcher->dispatch(ReturnUrlEvent::EVENT_NAME, $event);
    }

    public function emitReceivePaymentnumber(ReceivePaymentnumberEvent $event)
    {
        $this->dispatcher->dispatch(ReceivePaymentnumberEvent::EVENT_NAME, $event);
    }
    
    public function emitReceiveCreateOrder(ReceiveCreateOrderEvent $event)
    {
        $this->dispatcher->dispatch(ReceiveCreateOrderEvent::EVENT_NAME, $event);
    }

}