<?php
namespace Widget\PaymentBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\PaymentBundle\Event\ReturnUrlEvent;
use Widget\PaymentBundle\Model\OrderReturnUrlQuery;

/**
 * @DI\Service()
 */
class ReturnUrlListener
{
    /**
     * @DI\Observe("event.widget.payment.return.url")
     */
    public function returnUrl(ReturnUrlEvent $event)
    {
        $ordernumber = $event->getOrdernumber();
        if($orderReturnUrl = OrderReturnUrlQuery::create()->findOneByOrdernumber($ordernumber)) {
            $event->setUrl($orderReturnUrl->getReturnUrl());
        }
    }
}