<?php
namespace Widget\PaymentBundle\EventListener;
use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Inject;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\Routing\RequestContext;

/**
 * @DI\Service()
 */
class RequestListener
{
    /** @var RequestContext */
    protected $requestContext;
    protected $requestSchema;

    /**
     * @DI\InjectParams({
     *   "requestContext" = @Inject("router.request_context"),
     *   "requestSchema" = @Inject("%widget_payment.schema%")
     * })
     */
    public function injectRequestContext(RequestContext $requestContext, $requestSchema)
    {
        $this->requestContext = $requestContext;
        $this->requestSchema = $requestSchema;
    }

    /**
     * @DI\Observe("kernel.request")
     */
    public function onRequest(GetResponseEvent $event)
    {
        if($this->requestSchema == null){
            return;
        }
        $this->requestContext->setScheme($this->requestSchema);
    }
}