<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/13
 * Time: 上午 11:38
 */

namespace Widget\PaymentBundle\EventListener;


use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\ReceiveOrderQueryStatusEvent;
use Widget\PaymentBundle\Model\PaymentPeer;

/**
 * @DI\Service()
 */
class PaymentRecoverListener
{
    /**
     * @DI\Observe("event.receive.order.query.status")
     */
    public function onReceivePaymentQueryFailEvent(ReceiveOrderQueryStatusEvent $event)
    {
        $event->setProcessed(true);
        $event->getQuery()
            ->usePaymentQuery()
                ->filterByPaymentExpiredAt(time(), \Criteria::LESS_THAN)
                ->filterByPaymentPaid(true, \Criteria::NOT_EQUAL)
            ->endUse();
    }
}