<?php
namespace Widget\PaymentBundle\EventListener;


use JMS\DiExtraBundle\Annotation as DI;
use Widget\PaymentBundle\Event\PaymentExpiredEvent;
use Widget\PaymentBundle\Model\PaymentPeer;

/**
 * @DI\Service()
 */
class PaymentExpireListener
{
    /**
     * @DI\Observe(PaymentExpiredEvent::EVENT_NAME)
     */
    public function onPaymentExpired(PaymentExpiredEvent $event)
    {
        $con = $event->getCon();
        $order = $event->getOrder();
        $payment = $order->getPayment($con);
        $payment->setPaymentStatus(PaymentPeer::PAYMENT_STATUS_FAILED)->save($con);
    }
}