<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class UpdatePaymentTypeEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.update.payment.type';

    protected $ordernumber;
    protected $paymentType;
    protected $amount;
    protected $currency;
    protected $unit;

    public function __construct($ordernumber, $paymentType, $amount, $currency = 'TWD', $unit = 0)
    {
        $this->ordernumber = $ordernumber;
        $this->paymentType = $paymentType;
        $this->amount = $amount;
        $this->currency = $currency;
        $this->unit = $unit;
    }

    /**
     * @return string
     */
    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    /**
     * @return string
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }

    /**
     * @return integer
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @return int
     */
    public function getUnit()
    {
        return $this->unit;
    }
}