<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class QueryAvailablePaymentEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.query.available.payment';

    protected $amount;
    protected $payments = array();
    protected $endAt;

    public function __construct($amount, \DateTime $endAt = null)
    {
        $this->amount = $amount;
        $this->endAt = $endAt;
    }

    /**
     * @return \DateTime|null
     */
    public function getEndAt()
    {
        return $this->endAt;
    }

    public function getAmount()
    {
        return $this->amount;
    }

    public function addAvailablePayment($payment)
    {
        $this->payments[] = $payment;
    }

    public function getAvailablePayment()
    {
        return $this->payments;
    }


}