<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\PaymentBundle\Processer\ProcesserResult;
use Widget\PaymentBundle\Processer\ProcesserResultInterface;

class ProcessPaymentEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.process.event';

    protected $paymentType;
    protected $ordernumber;
    protected $amount;
    protected $paymentExtraInfo;
    protected $currency = 'TWD';
    protected $unit = 0;

    /** @var  ProcesserResultInterface */
    protected $processerResult;

    public function __construct($paymentType, $ordernumber, $amount, $paymentExtraInfo, $currency = null, $unit = null)
    {
        $this->processerResult = new ProcesserResult();
        $this->paymentType = $paymentType;
        $this->ordernumber = $ordernumber;
        $this->amount = $amount;
        $this->paymentExtraInfo = $paymentExtraInfo;
        if($currency !== null) {
            $this->currency = $currency;
        }
        if($unit !== null) {
            $this->unit = $unit;
        }
    }

    /**
     * @return ProcesserResultInterface
     */
    public function getProcesserResult()
    {
        return $this->processerResult;
    }

    /**
     * @param ProcesserResultInterface $processerResult
     */
    public function setProcesserResult($processerResult)
    {
        $this->processerResult = $processerResult;
    }

    public function getPaymentType()
    {
        return $this->paymentType;
    }

    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    public function getAmount()
    {
        return $this->amount;
    }

    public function getPaymentExtraInfo()
    {
        return $this->paymentExtraInfo;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @return int
     */
    public function getUnit()
    {
        return $this->unit;
    }
}