<?php
namespace Widget\PaymentBundle\Event;


use Symfony\Component\EventDispatcher\Event;
use Widget\OrderBundle\Model\Order;

class PaymentExpiredEvent extends Event
{
        const EVENT_NAME = 'event.payment.expired';

    /** @var Order  */
    protected $order;

    /** @var \PropelPDO  */
    protected $con;

    public function __construct(Order $order, \PropelPDO $con = null)
    {
        $this->order = $order;
        $this->con = $con;
    }

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return \PropelPDO
     */
    public function getCon(): \PropelPDO
    {
        return $this->con;
    }


}