<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class PaymentErrorEvent extends Event
{
    const EVENT_NAME = 'event.payment.error';

    protected $ordernumber;
    protected $reason;
    protected $originInfo;

    public function __construct($ordernumber, $reason, $originInfo)
    {
        $this->ordernumber = $ordernumber;
        $this->reason = $reason;
        $this->originInfo = $originInfo;
    }

    /**
     * @return mixed
     */
    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    /**
     * @return mixed
     */
    public function getReason()
    {
        return $this->reason;
    }

    /**
     * @return mixed
     */
    public function getOriginInfo()
    {
        return $this->originInfo;
    }
}