<?php
namespace Widget\PaymentBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\PaymentBundle\Model\Payment;
use Widget\PaymentBundle\Model\PaymentPeer;
use Widget\PaymentBundle\Model\PaymentQuery;

/**
 * @Route("/payment")
 * @Security("has_role_or_superadmin('ROLE_PAYMENT_READ')")
 */
class PaymentController extends BaseBackendAPIController
{

    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            new APIFormTypeItem('payment_status'),
        );
    }

    /**
     * 搜尋
     * @Route("s")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PAYMENT_READ')")
     */
    public function searchAction(Request $request)
    {
        return $this->doSearch($request->query->all(), PaymentQuery::create()->distinct(), PaymentPeer::class);
    }

    /**
     * 讀取
     * @Route("/{id}")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PAYMENT_READ')")
     */
    public function readAction(Payment $payment)
    {
        return $this->createJsonSerializeResponse($payment, array('detail', 'admin'));
    }

    /**
     * 讀取
     * @Route("s/all")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PAYMENT_READ')")
     */
    public function listAction(Request $request)
    {
        $payment = PaymentQuery::create()->find();
        if (!$payment){
            return new Response('', Response::HTTP_BAD_REQUEST);
        }
        return $this->createJsonSerializeResponse($payment, array('list'));
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_PAYMENT_WRITE')")
     */
    public function updateAction(Request $request, Payment $payment)
    {
        return $this->doProcessForm($payment, $request->getContent());
    }

    /**
     * 刪除
     * @Route("/{id}")
     * @Method({"DELETE"})
     */
    public function deleteAction()
    {
    }

    /**
     * 列出付款方式
     * @Route("s/payment")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PAYMENT_READ')")
     */
    public function paymentAction(Request $request)
    {
        $payment = PaymentQuery::create()->select(array('payment_type'))->distinct()->find();
        if (!$payment){
            return new Response('', Response::HTTP_BAD_REQUEST);
        }
        $responseArray = array();
        foreach ($payment->toArray() as $value){
            $responseArray[] = array(
                "id" => $value,
                "payment_type" => $value
            );
        }
        return $this->createJsonResponse($responseArray);
    }

}