<?php
namespace Widget\PaymentBundle\Controller\API;

use Backend\BaseBundle\Token\Service\Token;
use Backend\BaseBundle\Token\Service\TokenServiceInterface;
use JMS\DiExtraBundle\Annotation as DI;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Widget\OrderBundle\Service\PaymentToken;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;
use Widget\PaymentBundle\Model\OrderReturnUrl;
use Widget\PaymentBundle\Model\OrderReturnUrlQuery;
use Widget\PaymentBundle\Payment\Payment;

/**
 * @Route("/payment")
 */
class PaymentController extends Controller
{
    /**
     * @var PaymentToken
     * @DI\Inject("widget_order.payment.token", required=false)
     */
    protected $paymentTokenService;

    /**
     * @var TokenServiceInterface
     * @DI\Inject("token_service")
     */
    protected $tokenService;

    /**
     * @Route("/")
     * @Method({"POST"})
     */
    public function payAction(Request $request)
    {
        $url = $request->request->get('return_url');
        $paymentType = $request->request->get('payment_type');
        $currency = 'TWD';
        $unit = 0;

        if(!($token = $this->parseToken($request->request->get('token')))){
            throw $this->createNotFoundException();
        }

        if($token instanceof Token) {
            if($token->getType() != Payment::TokenType) {
                throw $this->createNotFoundException();
            }
            $ordernumber = $token->getId();
            $data = $token->getData();
            $price = $data['order']['price'];
            $currency = $data['order']['currency']??$currency;
            $unit = $data['order']['currency']??$unit;
            $info = $token->getId();
        }
        else{
            $ordernumber = $token->ordernumber;
            $price = $token->amount;
            $info = $token->info;
        }

        $orderReturnUrl = OrderReturnUrlQuery::create()
            ->filterByOrdernumber($ordernumber)
            ->findOneOrCreate();

        $orderReturnUrl
            ->setOrdernumber($ordernumber)
            ->setReturnUrl($url)
            ->save();

        $result = $this->get('widget_payment.payment')->processPayment($paymentType, $ordernumber, $price, $info, $currency, $unit);

        if(!$result->isProcessed()){
            throw $this->createNotFoundException();
        }

        return $result->makeResponse();
    }

    /**
     * 帶錢進來查有哪些可用金流
     * @Route("s")
     * @Method({"GET"})
     */
    public function readPaymentAction(Request $request)
    {
        $params = json_decode($request->getContent(), true);
        $event = new QueryAvailablePaymentEvent($params['amount']);
        return $event->getAvailablePayment();
    }

    /**
     * @param $jetToken
     * @return bool|mixed
     */
    protected function parseToken($jetToken)
    {
        if(($token = $this->tokenService->parse($jetToken)) && $token->getType() == 'order'){
            return $token;
        }

        if($this->paymentTokenService) {
            return $this->paymentTokenService->verifyToken($jetToken);
        }

        return null;
    }
}