<?php
namespace Widget\PaymentBundle\Tests\Service;

use Backend\BaseBundle\Model\Site;
use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use Backend\BaseBundle\SiteConfig\SiteConfigInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Widget\PaymentBundle\Service\SetupConfig;
use Widget\PaymentBundle\Tests\Controller\Front\PaymentFrontWebTestCase;

class SetupConfigTest extends PaymentFrontWebTestCase
{
    public function test_injectConfig()
    {
        //arrange
        $config = array(1, 2, 3, 4);
        $mockSiteConfig = $this->getMockBuilder(SiteConfigInterface::class)
            ->setMethods(array('__construct', 'set', 'get', 'delete'))
            ->getMock();
        $mockSiteConfig
            ->expects($this->once())
            ->method('get')
            ->willReturnCallback(function($configKey) use($config){
                $this->assertEquals('widget_payment', $configKey);
                return $config;
            });
        $siteConfigBuilder = $this->getMockBuilder(SiteConfigBuilder::class)
            ->setMethods(array('build'))
            ->getMock();
        $siteConfigBuilder
            ->expects($this->once())
            ->method('build')
            ->willReturnCallback(function() use($mockSiteConfig){
                return $mockSiteConfig;
            });
        $setupConfig = $this->getMockBuilder(SetupConfig::class)
            ->setMethods(array('exchangeArray'))
            ->getMock();
        $setupConfig
            ->expects($this->once())
            ->method('exchangeArray')
            ->willReturn(function($configForTest) use($config){
                $this->assertEquals($config, $configForTest);
            });

        //act
        $setupConfig->injectConfig($siteConfigBuilder);

        //assert
    }
}