<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\VerifyPaymentEvent;

class VerifyPaymentEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $paymentType = 'TestCredit';
        $ordernumber = 'o123456';

        //act
        $event = new VerifyPaymentEvent($paymentType, $ordernumber);

        //assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($event, 'ordernumber'));
        $this->assertEquals($paymentType, $this->getObjectAttribute($event, 'paymentType'));
    }

    public function test_getOrdernumber()
    {
        //arrange
        $ordernumber = 'o12345';
        $event = $this->getMockBuilder(VerifyPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'ordernumber', $ordernumber);

        //act
        $result = $event->getOrdernumber();

        //assert
        $this->assertEquals($ordernumber, $result);
    }

    public function test_getPaymentType()
    {
        //arrange
        $paymentType = 'TestCredit';
        $event = $this->getMockBuilder(VerifyPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'paymentType', $paymentType);

        //act
        $result = $event->getPaymentType();

        //assert
        $this->assertEquals($paymentType, $result);
    }

    public function test_getStatus()
    {
        //arrange
        $status = true;
        $event = $this->getMockBuilder(VerifyPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'status', $status);

        //act
        $result = $event->getStatus();

        //assert
        $this->assertEquals($status, $result);
    }

    public function test_setStatus()
    {
        //arrange
        $status = true;
        $event = $this->getMockBuilder(VerifyPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        //act
        $result = $event->setStatus($status);

        //assert
        $this->assertEquals($status, $this->getObjectAttribute($event, 'status'));
    }

    public function test_getOriginInfo()
    {
        //arrange
        $originInfo = range(0, 10);
        $event = $this->getMockBuilder(VerifyPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'info', $originInfo);

        //act
        $result = $event->getOriginInfo();

        //assert
        $this->assertEquals($originInfo, $result);
    }

    public function test_setOriginInfo()
    {
        //arrange
        $originInfo = range(0, 10);
        $event = $this->getMockBuilder(VerifyPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        //act
        $result = $event->setOriginInfo($originInfo);

        //assert
        $this->assertEquals($originInfo, $this->getObjectAttribute($event, 'info'));
    }
}