<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\UpdatePaymentTypeEvent;

class UpdatePaymentTypeEventTest extends BaseTestCase
{
    public function  test___construct()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType);

        // assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($updatePayment,'ordernumber'));
        $this->assertEquals($paymentType, $this->getObjectAttribute($updatePayment,'paymentType'));
    }

    public function test_getOrdernumber()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType);

        // assert
        $this->assertEquals($ordernumber, $updatePayment->getOrdernumber());

    }

    public function test_getPaymentType()
    {
        // arrange
        $ordernumber = "Test123";
        $paymentType = "Test ATM";

        // act
        $updatePayment = new UpdatePaymentTypeEvent($ordernumber, $paymentType);

        // assert
        $this->assertEquals($paymentType, $updatePayment->getPaymentType());
    }
}