<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;

class ReceiveOrderEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $paymentType = 'TestCredit';
        $ordernumber = 'o123456';
        $amount = 100;
        $originInfo = array(1, 2, 3, 4, 5);
        $status = false;

        //act
        $event = new ReceiveOrderEvent($ordernumber, $amount, $status, $paymentType, $originInfo);

        //assert
        $this->assertEquals($ordernumber, $this->getObjectAttribute($event, 'ordernumber'));
        $this->assertEquals($amount, $this->getObjectAttribute($event, 'amount'));
        $this->assertEquals($originInfo, $this->getObjectAttribute($event, 'originInfo'));
        $this->assertEquals($status, $this->getObjectAttribute($event, 'status'));
    }

    public function test_getOrdernumber()
    {
        //arrange
        $ordernumber = 'o12345';
        $event = $this->getMockBuilder(ReceiveOrderEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'ordernumber', $ordernumber);

        //act
        $result = $event->getOrdernumber();

        //assert
        $this->assertEquals($ordernumber, $result);
    }

    public function test_getAmount()
    {
        //arrange
        $amount = 1234;
        $event = $this->getMockBuilder(ReceiveOrderEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'amount', $amount);

        //act
        $result = $event->getAmount();

        //assert
        $this->assertEquals($amount, $result);
    }

    public function test_getStatus()
    {
        //arrange
        $status = true;
        $event = $this->getMockBuilder(ReceiveOrderEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'status', $status);

        //act
        $result = $event->getStatus();

        //assert
        $this->assertEquals($status, $result);
    }

    public function test_getOriginInfo()
    {
        //arrange
        $originInfo = array(0, 1, 2, 3, 4, 5);
        $event = $this->getMockBuilder(ReceiveOrderEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'originInfo', $originInfo);

        //act
        $result = $event->getOriginInfo();

        //assert
        $this->assertEquals($originInfo, $result);
    }

}