<?php

namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\QueryAvailablePaymentEvent;

class QueryAvailablePaymentEventTest extends BaseTestCase
{
    public function test___construct()
    {
        // arrange
        $amount = 500;

        // act
        $event = new QueryAvailablePaymentEvent($amount);

        // asset
        $this->assertEquals($amount, $this->getObjectAttribute($event, 'amount'));
    }

    public function test___construct_with_endat()
    {
        // arrange
        $amount = 500;
        $endAt = new \DateTime();

        // act
        $event = new QueryAvailablePaymentEvent($amount, $endAt);

        // asset
        $this->assertEquals($amount, $this->getObjectAttribute($event, 'amount'));
        $this->assertEquals($endAt, $this->getObjectAttribute($event, 'endAt'));
    }

    public function test_getEndAt()
    {
        // arrange
        $amount = 500;
        $endAt = new \DateTime();

        // act
        $event = new QueryAvailablePaymentEvent($amount, $endAt);

        // asset
        $this->assertEquals($endAt, $event->getEndAt());
    }

    public function test_getAmount()
    {
        // arrange
        $amount = 500;

        // act
        $event = new QueryAvailablePaymentEvent($amount);

        // asset
        $this->assertEquals($amount, $event->getAmount());
    }

    public function test_addAvailablePayment()
    {
        // arrange
        $event = $this->getMockBuilder(QueryAvailablePaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $payment = ['payment1' , 'payment2'];

        //act
        $event->addAvailablePayment('payment1');
        $event->addAvailablePayment('payment2');

        //asset
        $this->assertEquals($payment, $this->getObjectAttribute($event, 'payments') );
    }

    public function test_getAvailablePayment()
    {
        // arrange
        $event = $this->getMockBuilder(QueryAvailablePaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $payments = ['payment1' , 'payment2'];
        $this->setObjectAttribute($event, 'payments', $payments);

        // act
        $result = $event->getAvailablePayment();
        // asset
        $this->assertEquals($result, $this->getObjectAttribute($event, 'payments'));
    }
}