<?php
namespace Widget\PaymentBundle\Tests\Event;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\PaymentBundle\Event\ProcessPaymentEvent;
use Widget\PaymentBundle\Processer;

class ProcessPaymentEventTest extends BaseTestCase
{
    public function test___construct()
    {
        //arrange
        $paymentType = 'TestCredit';
        $ordernumber = 'o123456';
        $amount = 100;
        $paymentExtraInfo = array(1, 2, 3, 4, 5);

        //act
        $event = new ProcessPaymentEvent($paymentType, $ordernumber, $amount, $paymentExtraInfo);

        //assert
        $this->assertInstanceOf(Processer\ProcesserResult::class, $this->getObjectAttribute($event, 'result'));
        $this->assertEquals($paymentType, $this->getObjectAttribute($event, 'paymentType'));
        $this->assertEquals($ordernumber, $this->getObjectAttribute($event, 'ordernumber'));
        $this->assertEquals($amount, $this->getObjectAttribute($event, 'amount'));
        $this->assertEquals($paymentExtraInfo, $this->getObjectAttribute($event, 'paymentExtraInfo'));
    }

    public function test_getProcesserResult()
    {
        //arrange
        $event = $this->getMockBuilder(ProcessPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $processerResult = $this->getMockBuilder(Processer\ProcesserResult::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'result', $processerResult);
        //act
        $result = $event->getProcesserResult($processerResult);

        //assert
        $this->assertEquals($processerResult, $result);
    }

    public function test_getPaymentType()
    {
        //arrange
        $paymentType = 'TestCredit';
        $event = $this->getMockBuilder(ProcessPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'paymentType', $paymentType);

        //act
        $result = $event->getPaymentType();

        //assert
        $this->assertEquals($paymentType, $result);
    }

    public function test_getOrdernumber()
    {
        //arrange
        $ordernumber = 'o12345';
        $event = $this->getMockBuilder(ProcessPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'ordernumber', $ordernumber);

        //act
        $result = $event->getOrdernumber();

        //assert
        $this->assertEquals($ordernumber, $result);
    }

    public function test_getAmount()
    {
        //arrange
        $amount = 1234;
        $event = $this->getMockBuilder(ProcessPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'amount', $amount);

        //act
        $result = $event->getAmount();

        //assert
        $this->assertEquals($amount, $result);
    }

    public function test_getPaymentExtraInfo()
    {
        //arrange
        $paymentExtraInfo = array(1, 2, 3, 4, 5);
        $event = $this->getMockBuilder(ProcessPaymentEvent::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $this->setObjectAttribute($event, 'paymentExtraInfo', $paymentExtraInfo);

        //act
        $result = $event->getPaymentExtraInfo();

        //assert
        $this->assertEquals($paymentExtraInfo, $result);
    }

}