<?php
namespace Widget\PaymentBundle\Tests\Controller\Front;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Symfony\Component\DomCrawler\Crawler;

class CommonControllerTest extends BaseWebTestCase
{

    public function test_forwardPOSTAction()
    {
        //arrange
        $url = 'abcdefg';
        $params = array(
            'a' => 'va',
            'b' => 'vb',
            'c' => 'vc',
        );

        $container = $this->client->getContainer();
        $request = Request::createFromGlobals();
        $subRequest = $request->duplicate(null, null, array(
            '_controller' => 'WidgetPaymentBundle:Front/Common:forwardPost',
            'url' => $url,
            'params' => $params,
        ));
        $response = $container->get('kernel')->handle($subRequest, HttpKernelInterface::SUB_REQUEST);
        $this->assertTrue($response->isOk());

        $crawler = new Crawler($response->getContent());
        $form = $crawler->filter('#post-form');
        $this->assertEquals('POST', strtoupper($form->attr('method')));
        $this->assertEquals($url, $form->attr('action'));

        foreach($params as $key => $value){
            $this->assertEquals($value, $crawler->filter('#post-form input[name="'.$key.'"]')->attr('value'), "form input field $key");
        }
    }
}