<?php

namespace Widget\PaymentBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\PaymentBundle\Model\PaymentQuery;

class PaymentControllerTest extends BackendWebTestCase
{
    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $searchParams = array(
            'payment_status' => 'n'
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_payment_backendapi_payment_search', $searchParams),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('payment_type', $responseArray['data'][0]);
        $this->assertArrayHasKey('payment_expired_at', $responseArray['data'][0]);
        $this->assertArrayHasKey('payment_number', $responseArray['data'][0]);
        $this->assertArrayHasKey('payment_status', $responseArray['data'][0]);
        $this->assertArrayHasKey('payment_paid_at', $responseArray['data'][0]);
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $payment = PaymentQuery::create()->findOneById('P0000');
        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_payment_backendapi_payment_read', array('id' => $payment->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($payment->getPaymentType(), $responseArray['payment_type']);
        $this->assertEquals($payment->getPaymentExpiredAt(DATE_RFC3339), $responseArray['payment_expired_at']);
        $this->assertEquals($payment->getPaymentNumber(), $responseArray['payment_number']);
        $this->assertEquals($payment->getPaymentStatus(), $responseArray['payment_status']);
        $this->assertEquals($payment->getPaymentPaidAt(DATE_RFC3339), $responseArray['payment_paid_at']);
    }

    public function test_updateAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $payment = PaymentQuery::create()->findOneById('P0000');
        $params = array(
            'payment_status' => 'p'
        );

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_payment_backendapi_payment_update', array('id' => $payment->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);


        // assert
        $this->assertEquals($params['payment_status'], $responseArray['payment_status']);

        // reset
        $payment->setPaymentStatus('n');
        $payment->save();
    }
}