<?php
namespace Widget\PaymentBundle\Processer;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Router;

class ProcesserResult
{
    /** @var \Twig_Environment  */
    protected $twig;

    protected $isRedirect = false;
    protected $isProcessed = false;
    protected $target = null;
    protected $params = null;

    public function setTwig(\Twig_Environment $twig)
    {
        $this->twig = $twig;
        return $this;
    }

    public function isProcessed()
    {
        return $this->isProcessed;
    }

    public function setForwardPost($targetUrl, $params = array())
    {
        $this->isProcessed = true;
        $this->isRedirect = false;
        $this->target = $targetUrl;
        $this->params = $params;
        return $this;
    }

    public function setForwardRedirect($targetUrl, $params = array())
    {
        $this->isProcessed = true;
        $this->isRedirect = true;
        $this->target = $targetUrl;
        $this->params = $params;
        return $this;
    }

    /**
     * @param $url
     * @param $params
     * @return RedirectResponse
     */
    protected function makeRedirectResponse($url, $params)
    {
        $queryString = http_build_query($params);
        if($queryString !== ''){
            if (strpos($url, '?') === false) {
                $targetUrl = "$url?$queryString";
            } else {
                $targetUrl = "$url&$queryString";
            }
        }
        else{
            $targetUrl = $url;
        }
        return new RedirectResponse($targetUrl);
    }

    protected function makePostResponse($url, $params)
    {
        $content = $this->twig->render('WidgetPaymentBundle:Front/Common:forwardPost.html.twig', array(
            'url' => $url,
            'params' => $params,
        ));
        return new Response($content);
    }

    public function makeResponse()
    {
        if($this->isRedirect){
            return $this->makeRedirectResponse($this->target, $this->params);
        }
        return $this->makePostResponse($this->target, $this->params);
    }
}