<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class VerifyPaymentEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.verity.payment';

    protected $ordernumber;
    protected $paymentType;
    protected $valid = false;
    protected $status = false;
    protected $info;

    public function __construct($paymentType, $ordernumber)
    {
        $this->ordernumber = $ordernumber;
        $this->paymentType = $paymentType;
    }

    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    public function getPaymentType()
    {
        return $this->paymentType;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function setStatus($status)
    {
        $this->status = $status;
    }

    public function setOriginInfo($info)
    {
        $this->info = $info;
    }

    public function getOriginInfo()
    {
        return $this->info;
    }
}