<?php
namespace Widget\PaymentBundle\Event;

use Symfony\Component\EventDispatcher\Event;

class VerifyAmountEvent extends Event
{
    const EVENT_NAME = 'event.widget.payment.verity.amount';

    protected $ordernumber;
    protected $amount;
    protected $valid = false;

    public function __construct($ordernumber, $amount)
    {
        $this->ordernumber = $ordernumber;
        $this->amount = $amount;
    }

    public function getOrdernumber()
    {
        return $this->ordernumber;
    }

    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param $result bool
     */
    public function setValid($valid)
    {
        $this->valid = (bool) $valid;
    }

    /**
     * @return bool
     */
    public function isValid()
    {
        return $this->valid;
    }
}